<?php
require "auth.php";
require_once "../config/db.php";

/* افزودن بازی */
if (isset($_POST['add'])) {
    $stmt = $pdo->prepare("INSERT INTO games (title, status) VALUES (?, 1)");
    $stmt->execute([$_POST['title']]);
}

/* تغییر وضعیت */
if (isset($_GET['toggle'])) {
    $stmt = $pdo->prepare("UPDATE games SET status = IF(status=1,0,1) WHERE id=?");
    $stmt->execute([$_GET['toggle']]);
}

/* لیست بازی‌ها */
$games = $pdo->query("SELECT * FROM games ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<h2>مدیریت بازی‌ها</h2>

<form method="post">
    <input name="title" placeholder="نام بازی" required>
    <button name="add">افزودن بازی</button>
</form>

<table border="1">
<tr>
    <th>ID</th>
    <th>نام</th>
    <th>وضعیت</th>
    <th>عملیات</th>
</tr>

<?php foreach ($games as $g): ?>
<tr>
    <td><?= $g['id'] ?></td>
    <td><?= $g['title'] ?></td>
    <td><?= $g['status'] ? 'فعال' : 'غیرفعال' ?></td>
    <td>
        <a href="?toggle=<?= $g['id'] ?>">تغییر وضعیت</a> |
        <a href="items.php?game=<?= $g['id'] ?>">آیتم‌ها</a>
    </td>
</tr>
<?php endforeach; ?>
</table>