<?php

$game_id = intval(str_replace("game_", "", $data));

$stmt = $pdo->prepare("
    SELECT id, title, price 
    FROM items 
    WHERE game_id = ? AND status = 1
");
$stmt->execute([$game_id]);
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);

if (!$items) {
    sendMessage(
        $chat_id,
        "❌ آیتمی برای این بازی ثبت نشده است.",
        [
            'inline_keyboard' => [
                [
                    ['text' => '🔙 بازگشت', 'callback_data' => 'show_games']
                ]
            ]
        ]
    );
    return;
}

$inline = [];
foreach ($items as $item) {
    $inline[] = [
        [
            'text' => "{$item['title']} | 💰 {$item['price']} تومان",
            'callback_data' => "item_" . $item['id']
        ]
    ];
}

$inline[] = [
    ['text' => '🔙 بازگشت به بازی‌ها', 'callback_data' => 'show_games']
];

sendMessage(
    $chat_id,
    "🛒 آیتم مورد نظر را انتخاب کنید:",
    ['inline_keyboard' => $inline]
);