<?php
function rateLimit($pdo, $telegram_id, $action, $seconds = 2) {
    $now = time();

    $stmt = $pdo->prepare("
        SELECT last_time FROM rate_limits
        WHERE telegram_id=? AND action=?
    ");
    $stmt->execute([$telegram_id, $action]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row && ($now - $row['last_time']) < $seconds) {
        return false;
    }

    $stmt = $pdo->prepare("
        REPLACE INTO rate_limits (telegram_id, action, last_time)
        VALUES (?, ?, ?)
    ");
    $stmt->execute([$telegram_id, $action, $now]);

    return true;
}