<?php
require_once "../config/db.php";
require_once "../config/bot.php";

$update = json_decode(file_get_contents("php://input"), true);

$message = $update['message'] ?? null;
$callback = $update['callback_query'] ?? null;
require_once "utils/rate_limit.php";

if ($callback && !rateLimit($pdo, $callback['from']['id'], 'callback')) {
    exit;
}

/* تابع ارسال پیام */
function sendMessage($chat_id, $text, $keyboard = null) {
    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];
    if ($keyboard) {
        $data['reply_markup'] = json_encode($keyboard);
    }
    file_get_contents(API_URL . "sendMessage?" . http_build_query($data));
}

/* ثبت کاربر */
if ($message) {
    global $pdo;
    $user = $message['from'];
    $stmt = $pdo->prepare(
        "INSERT IGNORE INTO users (telegram_id, username, first_name) VALUES (?, ?, ?)"
    );
    $stmt->execute([
        $user['id'],
        $user['username'] ?? null,
        $user['first_name'] ?? null
    ]);
}

/* پیام‌ها */
if ($message) {
    $chat_id = $message['chat']['id'];
    $text = $message['text'] ?? '';

    if ($text == "/start") {
        require "handlers/start.php";
    }

    if ($text == "🎮 لیست بازی‌ها") {
        require "handlers/games.php";
    }
    if ($data == "show_games") {
    require "handlers/games.php";
    }
    if ($message && isset($message['photo'])) {
    require "handlers/receipt.php";
    }
}

/* کلیک روی دکمه‌ها */
if ($callback) {
    $chat_id = $callback['message']['chat']['id'];
    $data = $callback['data'];

    if (strpos($data, "game_") === 0) {
        require "handlers/items.php";
    }
    if (strpos($data, "item_") === 0) {
    require "handlers/quantity.php";
    }
    if (strpos($data, "qty_") === 0) {
    require "handlers/order_create.php";
    }
    if (strpos($data, "pay_") === 0) {
    require "handlers/payment_method.php";
    }
    if (strpos($data, "card_") === 0) {
    require "handlers/card_payment.php";
    }
    if ($data == "my_orders") {
    require "handlers/my_orders.php";
    }

    if (strpos($data, "order_") === 0) {
    require "handlers/order_detail.php";
    }
}