<?php
require_once "../config/db.php";
require_once "../config/payment.php";

$order_id = intval($_GET['order']);

$stmt = $pdo->prepare("SELECT * FROM orders WHERE id=? AND status='pending'");
$stmt->execute([$order_id]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) die("Invalid Order");

$data = [
    "merchant_id" => ZARINPAL_MERCHANT,
    "amount" => (int)$order['total_price'],
    "callback_url" => ZARINPAL_CALLBACK . "?order=" . $order_id,
    "description" => "پرداخت سفارش #" . $order_id
];

$ch = curl_init("https://api.zarinpal.com/pg/v4/payment/request.json");
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POSTFIELDS => json_encode($data),
    CURLOPT_HTTPHEADER => ['Content-Type: application/json']
]);
$response = json_decode(curl_exec($ch), true);

if ($response['data']['code'] == 100) {
    header("Location: https://www.zarinpal.com/pg/StartPay/" . $response['data']['authority']);
    exit;
}

die("Payment Error");